//optical encoder ring
//units are [mm]
use <ccube.scad>

module ring(){
    ring_id=44;
    ring_od=85;
    ebrs=27;//radius for encoder bolts
    //ring_th=0.31;
    difference(){
        //cylinder($fn=50,h=ring_th,d=ring_od);
        circle($fn=50,d=ring_od);
        //translate([0,0,-1])cylinder($fn=50,h=ring_th+2,d=ring_id);
        circle($fn=50,d=ring_id);
        for(a=[0:60:359]) rotate([0,0,a])translate([ebrs,0,0])circle($fn=12,d=2.6);//holes for encoder bolts
    }
}

module tab(tr,ta,tw){
    //tab radius, tab angle, tab width
    //makes a 4-line polygon centered at (tr,0) of extents tw in x and with its top and bottom sides forming angle ta
    //ring_th=3;
    th=2*tr*tan(0.5*ta);
    h=th/tr*(tr-0.5*tw);
    j=th/tr*(tr+0.5*tw);
    //q=0.5;//(0.5*th-h)/(0.5*tw);
    
    /*translate([td,0,ring_th/2]) rotate([0,0,-90]) rotate([90,0,0]) intersection(){
        rotate([0,0,45]) cylinder($fn=4,h=tw,d1=sqrt(2)*j,d2=sqrt(2)*h,center=true);
        cube([2*j,ring_th+2,tw+2],center=true);
    }*/
    
    /*CubePoints = [
      [  -tw/2, -h/2,  0 ],  //0
      [ tw/2,  -j/2,  0 ],  //1
      [ tw/2,  j/2,  0 ],  //2
      [  -tw/2,  h/2,  0 ],  //3
      [  -tw/2, -h/2, ring_th+2 ],  //4
      [ tw/2, -j/2, ring_th+2 ],  //5
      [ tw/2, j/2, ring_th+2 ],  //6
      [  -tw/2, h/2, ring_th+2 ]]; //7
      
    CubeFaces = [
      [0,1,2,3],  // bottom
      [4,5,1,0],  // front
      [7,6,5,4],  // top
      [5,6,2,1],  // right
      [6,7,3,2],  // back
      [7,4,0,3]]; // left
      
    translate([tr,0,-1]) polyhedron( CubePoints, CubeFaces );*/
    
    translate([tr,0,-1]) polygon( points=[[-tw/2,-h/2],[tw/2,-j/2],[tw/2,j/2],[-tw/2,h/2]] );
}

module tabs(){
    tabs_id=75;//inner diameter of tab cutouts
    tabs_od=80;//outer diameter of tab cutouts
    numtabs=256;//optical transitions (rising+falling edges) is twice the number of tab cutouts
    extradist=0.25;//additional solid distance to add to solid part between tabs to improve duty cycle of optical switch (with a low optical threshold, this should match the width of the optical sensor window)
    tw=(tabs_od-tabs_id)/2;//tab width
    tr=(tabs_od+tabs_id)/4;//tab radius
    ta=180/numtabs-(extradist/tr)*(180/PI);//tab cutout angle
    th=2*tr*tan(0.5*ta);
    echo("Tab cutout width ",th);
    
    ma=360-360/numtabs;
    for(i=[1:numtabs]){
        a=(i/numtabs)*360;
        if(i==1){
            da=(360/numtabs)*0.02;
            rotate([0,0,a+da]) tab(tr-0.2,ta-2*da,tw+0.4);
        }else{
            rotate([0,0,a]) tab(tr,ta,tw);
        }
    }
    //rotate([0,0,0.5/numtabs*360]) tab(tr,3*ta,tw);
}

module optoisolator(){
    //OPB940 wired type
    //optical center point is at X=6.8, Y=0, Z=7.75
    //mounting surface is ZY plane, encoder disc should be parallel to ZY plane and centered at positive Z,X
    difference(){
        translate([0,-23.75/2,2.79])cube([2.03,23.75,6.35]);//bolt mounting plastic
        translate([-1,-7.11-5.84/2,2.79+1.59])cube([4,5.84,3.18]);//bolt mounting slot
        translate([-1,7.11-5.84/2,2.79+1.59])cube([4,5.84,3.18]);//bolt mounting slot
    }
    difference(){
        translate([0,-6.35/2,0])cube([12.95,6.35,10.54]);//main body
        translate([5.21,-6,2.54])cube([3.18,12,12]);//main cutout for encoder disc
    }
    translate([2,-5/2,-8])cube([3,5,9]);//wires
    translate([8,-5/2,-8])cube([3,5,9]);//wires
    translate([6.8,0,7.75])cube([1.27,1.27,1.27],center=true); //optical center indicator
}

module optoextender(){
    //top for mounting OPB940 is at Z=0
    difference(){
        $fn=12;
        ccube([7,39,5],[0.5,0.5,1]);
        for(a=[-1,1]){
            translate([0,a*7,-6])cylinder(h=7,d=3);//bolts to go to photointerrupter
            translate([0,a*16,-6])cylinder(h=7,d=3);//bolts to go to box
            translate([0,a*16,-6])cylinder(h=3,d=5);//extra cutout to avoid melted plastic regions
        }
        translate([0,0,-6])ccube([8,24,3],[0.5,0.5,0]);
    }    
}

module optoisolatorasm(){
   //bottom surface at Z=0 //translate([7.75,0,-6.8])rotate([0,-90,0])optoisolator(); //optical center at origin
    translate([2.79+3.18,0,0])rotate([0,-90,0])optoisolator(); //bolt slots on Y axis, optical center at [-1.78,0,6.8]
}

module ring3d(){
    translate([0,0,-0.31/2])
    linear_extrude(0.31)
    ring2d();
}

module ring2d(){
    difference(){
        ring();
        tabs();
    }
}

ring2d();

//optoisolatorasm();

//translate([77.5/2,0,0])translate([7.75,0,-6.8])rotate([0,-90,0])optoisolator();
